<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${item.getPSSystemModule().codeName?lower_case}.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonProperty.Access;
import lombok.Data;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.cglib.beans.BeanGenerator;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import java.util.Map;
import java.util.HashMap;
import org.springframework.util.StringUtils;
import ${pub.getPKGCodeName()}.ibizutil.security.AuthenticationUser;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import org.springframework.cglib.beans.BeanCopier;
import ${pub.getPKGCodeName()}.ibizutil.annotation.Dict;
import ${pub.getPKGCodeName()}.ibizutil.domain.EntityBase;
import java.io.Serializable;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.math.BigInteger;
import ${pub.getPKGCodeName()}.ibizutil.enums.FillMode;
import ${pub.getPKGCodeName()}.ibizutil.enums.PredefinedType;
import ${pub.getPKGCodeName()}.ibizutil.annotation.PreField;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;

<#assign auditMode=de.getAuditMode()>
<#if item.getMajorPSDERs?? && item.getMajorPSDERs()??>
    <#list item.getMajorPSDERs() as MajorPSDER>
    <#if MajorPSDER?? && MajorPSDER.getDERType()=='DER1N'>
    <#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()??>
        <#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
        <#if MinorEntity.getCodeName?? && MajorPSDER.getCodeName()?? && MajorPSDER.getMinorCodeName?? && MajorPSDER.getMinorCodeName()??>
        <#if MajorPSDER.getMinorCodeName()!=''>
import ${pub.getPKGCodeName()}.${MinorEntity.getPSSystemModule().codeName?lower_case}.domain.${MinorEntity.codeName};
        </#if>
        </#if>
    </#if>
    </#if>
    </#list>
</#if>
<#if item.getMinorPSDERs?? && item.getMinorPSDERs()??>
    <#list item.getMinorPSDERs() as MinorPSDER>
    <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
    <#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()??>
        <#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
        <#if MajorEntity.getCodeName?? && MinorPSDER.getCodeName()?? >
import ${pub.getPKGCodeName()}.${MajorEntity.getPSSystemModule().codeName?lower_case}.domain.${MajorEntity.codeName};
        </#if>
    </#if>
    </#if>
    </#list>
</#if>

/**
 * 实体[${item.codeName}] 数据对象
 */
@TableName(value = "${item.getTableName()}",resultMap = "${item.codeName}ResultMap")
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class ${item.codeName} extends EntityBase implements Serializable{

<#comment>1：N关系中，在父实体中创建子实体的List集合</#comment>
<#if item.getMajorPSDERs?? && item.getMajorPSDERs()??>
    <#list item.getMajorPSDERs() as MajorPSDER>
    <#if MajorPSDER??>
    <#if MajorPSDER.getMinorPSDataEntity?? && MajorPSDER.getMinorPSDataEntity()?? && MajorPSDER.getMinorCodeName?? && MajorPSDER.getMinorCodeName()?? && MajorPSDER.getDERType()=='DER1N'>
        <#assign MinorEntity = MajorPSDER.getMinorPSDataEntity()>
        <#if MinorEntity.getCodeName?? && MajorPSDER.getCodeName()?? && MajorPSDER.getMinorCodeName()!=''>
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)//关系子表数据
    private List <${MinorEntity.getCodeName()}> ${MajorPSDER.getMinorCodeName()?lower_case};
        </#if>
    </#if>
    </#if>
    </#list>
</#if>
<#comment>创建1：N关系实体-输出主实体</#comment>
<#if item.getMinorPSDERs?? && item.getMinorPSDERs()??>
    <#list item.getMinorPSDERs() as MinorPSDER>
    <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
    <#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()?? && MinorPSDER.getCodeName?? && MinorPSDER.getCodeName()??>
        <#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
        <#if MajorEntity.getCodeName?? && MinorPSDER.getCodeName()?? >
    @JsonIgnore
    @JSONField(serialize = false)
    @TableField(exist = false)//关系主表数据
    private ${MajorEntity.getCodeName()} ${MinorPSDER.getCodeName()?lower_case};
        </#if>
    </#if>
    </#if>
    </#list>
</#if>
<#list item.getPSDEFields() as defield>
<#if !item.isVirtual() >
<#if defield.isKeyDEField()>
    @TableId(value= "${defield.getName()?lower_case}",type=IdType.UUID)//指定主键生成策略
<#comment>数据库字段do名称映射，防止SQL使用代码名称查询报错</#comment>
<#else>
    <#if defield.getName()?lower_case != defield.getCodeName()?lower_case>
    @TableField(value= "${defield.getName()?lower_case}")
    </#if>
</#if>
<#comment>系统预置属性</#comment>
<#if  defield.getPredefinedType?? && defield.getPredefinedType()??>
    <#comment>逻辑有效</#comment>
    <#if defield.getPredefinedType()?lower_case =='logicvalid'>
    @Dict(dictName = "${sys.codeName}_YesNoCodeList")
        <#if item.getLogicValidPSDEField()?? && item.getInvalidLogicValue()?? && item.isLogicValid()==true>
    @TableLogic(value= "${item.getValidLogicValue()}",delval="${item.getInvalidLogicValue()}")//设定逻辑有效属性
    @TableField(fill = FieldFill.INSERT)
        </#if>
    </#if>
    <#comment>系统预置属性赋值</#comment>
    <#if defield.getPredefinedType()?lower_case =='createman' >
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEMAN)
    <#elseif defield.getPredefinedType()?lower_case =='createmanname'>
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEMANNAME)
    <#elseif defield.getPredefinedType()?lower_case =='updateman'>
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEMAN)
    <#elseif defield.getPredefinedType()?lower_case =='updatemanname'>
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEMANNAME)
    <#elseif defield.getPredefinedType()?lower_case =='createdate'>
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.CREATEDATE)
    <#elseif defield.getPredefinedType()?lower_case =='updatedate'>
    @PreField(fill= FillMode.INSERT_UPDATE,preType = PredefinedType.UPDATEDATE)
    <#elseif defield.getPredefinedType()?lower_case =='orgid'>
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.ORGID)
    <#elseif defield.getPredefinedType()?lower_case =='orgname'>
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.ORGNAME)
    <#elseif defield.getPredefinedType()?lower_case =='orgsectorid'>
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.ORGSECTORID)
    <#elseif defield.getPredefinedType()?lower_case =='orgsectorname'>
    @PreField(fill= FillMode.INSERT,preType = PredefinedType.ORGSECTORNAME)
    </#if>
</#if>
<#comment>逻辑属性-非物理化</#comment>
<#if defield.isPhisicalDEField()==false>
    @TableField(exist = false)//逻辑属性
</#if>
<#comment>代码表注解</#comment>
<#if defield.getPSCodeList?? && defield.getPSCodeList()??>
    <#if ((defield.getPredefinedType())!'')!='LOGICVALID'>
    @Dict(dictName = "${sys.codeName}_${defield.getPSCodeList().codeName}CodeList")
    </#if>
</#if>
<#comment>审计注解</#comment>
<#if defield.isEnableAudit()==true && auditMode!=0>
    <#assign auditExpression=getAuditExpression(defield)>
    @${pub.getPKGCodeName()}.ibizutil.annotation.Audit(${auditExpression})
</#if>
    <#assign defDataType = (defield.getDataType())!"">
    <#assign dataType="${srfdatatype(defield.getStdDataType())}"><#comment>外键值附加数据时间格式转换</#comment>
    <#if defDataType == "DATETIME" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    <#elseif defDataType == "DATE" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defield.getValueFormat()=="%1$tY-%1$tm-%1$td")>
    @JsonFormat(pattern="yyyy-MM-dd", locale = "zh" , timezone="GMT+8")
    <#elseif defDataType == "TIME" || (defDataType=='PICKUPDATA' && dataType== "DATETIME" && defield.getValueFormat()=="%1$tH:%1$tM:%1$tS")>
    @JsonFormat(pattern="HH:mm", locale = "zh" , timezone="GMT+8")
    </#if>
    private ${srfjavatype(defield.stdDataType)} ${defield.codeName?lower_case};
</#if>
</#list>
<#list item.getPSDEFields() as defield>
<#if !item.isVirtual() >
<#comment>当属性名称与代码名称不一致时，多发一套get属性名称方法给gridvo用</#comment>
<#if defield.codeName?lower_case != defield.name?lower_case>
     /**
     *    ${defield.codeName?lower_case} :${defield.name?lower_case}
     *   当属性名称与代码名称不一致时，
     *   多发一套get属性名称方法给gridvo用
     */
    public ${srfjavatype(defield.stdDataType)} get${defield.name?lower_case?cap_first}(){
        return  ${defield.codeName?lower_case};
    }
</#if>
<#comment>关闭mp驼峰转换，当属性名称与代码名称不一致时，多发一套set用于值注入</#comment>
<#if defield.codeName?lower_case != defield.name?lower_case>
     /**
     *    ${defield.codeName?lower_case} :${defield.name?lower_case}
     *   关闭mp驼峰转换，当属性名称与代码名称不一致时，多发一套set用于值注入
     */
    public void set${defield.name?lower_case?cap_first}(${srfjavatype(defield.stdDataType)} ${defield.name?lower_case}){
        this.${defield.codeName?lower_case}=${defield.name?lower_case};
    }
</#if>
<#if defield.getDataType?? && defield.getDataType()??>
    <#if ((defield.getDataType()=='PICKUPDATA'  || defield.getDataType()=='PICKUPTEXT' ) && defield.isPhisicalDEField()==true  && defield.getPSDER1N?? && defield.getPSDER1N()??)
    || (defield.getPredefinedType()?lower_case =='logicvalid' && item.isLogicValid()==true)><#comment>当属性为外键值与逻辑有效值时才发Get方法</#comment>
    /**
     *  获取属性值[${defield.logicName}]
     */
    public ${srfjavatype(defield.stdDataType)} get${defield.codeName?lower_case?cap_first}(){
    <#if (defield.getDataType()=='PICKUPDATA'  || defield.getDataType()=='PICKUPTEXT' ) && defield.isPhisicalDEField()==true  && defield.getPSDER1N?? && defield.getPSDER1N()??>
        <#assign  MajorEntityCode=defield.getPSDER1N().codeName?lower_case?cap_first>               <#comment>关系代码</#comment>
        <#assign  RelatedPSDEFieldName=defield.getRelatedPSDEField().codeName?lower_case?cap_first> <#comment>关联属性</#comment>
        <#assign  PSPickupDEFieldName=defield.getPSPickupDEField().codeName?lower_case?cap_first>   <#comment>外键属性</#comment>
        //填充物理化的外键值附加数据
        if(StringUtils.isEmpty(this.${defield.codeName?lower_case})&&(!StringUtils.isEmpty(this.get${PSPickupDEFieldName}())) && this.get${MajorEntityCode}()!=null)
        {
            this.${defield.codeName?lower_case} = this.get${MajorEntityCode}().get${RelatedPSDEFieldName}();
        }
    <#elseif defield.getPredefinedType()?lower_case =='logicvalid' && item.isLogicValid()==true>
        <#if item.getLogicValidPSDEField()?? && item.getInvalidLogicValue()??>
        if(StringUtils.isEmpty(${defield.codeName?lower_case}))
        {
        <#if srfjavatype(defield.stdDataType)=='String'>
            this.${defield.codeName?lower_case} = "${item.getValidLogicValue()}";//设置逻辑有效值
        <#else>
            this.${defield.codeName?lower_case} = ${item.getValidLogicValue()};//设置逻辑有效值
        </#if>
        }
        </#if>
    </#if>
        return this.${defield.codeName?lower_case};
    }
    </#if>
</#if>
</#if>
</#list>
<#assign keyfield=item.getKeyPSDEField()>
<#comment>发srfkey用于审计</#comment>
    <#if auditMode!=0>
    @Override
    public Object getSrfkey() {
        return this.${keyfield.codeName?lower_case};
    }
    @Override
    public void setSrfkey(Object srfkey) {
        if(srfkey!=null){
            this.${keyfield.codeName?lower_case}=(${srfjavatype(keyfield.stdDataType)})srfkey;
        }
    }
    </#if>
<#if item.getUnionKeyValuePSDEFields()?? || srfjavatype(keyfield.stdDataType)=='BIGINT'><#comment>处理联合主键以及BIGINT类型主键</#comment>
     /**
     * 获取数据主键（普通主键与联合主键）
     * @return
     */
    @JsonIgnore
    public Serializable getDefaultPrimaryKey()
    {
<#if item.getUnionKeyValuePSDEFields()??>
    	//联合主键
        String primaryKey ="";
        <#assign bprimarykeyfirst=true>
    <#list item.getUnionKeyValuePSDEFields() as defield>
        <#assign second="this.get"+defield.codeName?lower_case?cap_first+"()">
        <#if !bprimarykeyfirst>
        primaryKey+="||";
        <#else >
            <#assign bprimarykeyfirst=false>
        </#if>
        primaryKey+=${second};
    </#list>
        return  DigestUtils.md5DigestAsHex(primaryKey.getBytes());
<#else>
	    //随机生成主键
         <#if srfjavatype(keyfield.stdDataType)=='BIGINT'>
         return new java.math.BigInteger(64,new java.util.Random());
         <#else>
         return  IdWorker.get32UUID();
        </#if>
</#if>
    }
</#if>
     /**
     * 复制当前对象数据到目标对象(粘贴重置)
     *
     * @throws Exception
     */
    public ${item.codeName} copyTo(${item.codeName} targetEntity)
	{
		BeanCopier copier=BeanCopier.create(${item.codeName}.class, ${item.codeName}.class, false);
		copier.copy(this, targetEntity, null);
        <#list item.getAllPSDEFields() as defield>
            <#if defield.isPasteReset()==true>
        targetEntity.set${defield.codeName?lower_case?cap_first}(null);
            </#if>
        </#list>
		return targetEntity;
	}
}
<#comment>返回审计注解表达式</#comment>
<#function getAuditExpression defield>
    <#assign defDataType = (defield.getDataType())!"">
    <#assign defStdType=srfjavatype(defield.stdDataType)>
    <#assign expressionCond="fieldLogicName=\""+ defield.getLogicName()+"\"">    //拼接字段逻辑名
        <#if defield.getPSCodeList?? && defield.getPSCodeList()??>
            <#if ((defield.getPredefinedType())!'')!='LOGICVALID'>
                <#assign expressionCond=expressionCond+",dictName=\""+ sys.codeName+"_"+defield.getPSCodeList().codeName+"CodeList"+"\""> //拼接代码表
            </#if>
        </#if>
        <#if defDataType == "DATETIME">//拼接时间
            <#assign expressionCond=expressionCond+",fieldType=\"DATETIME\",format=\"yyyy-MM-dd HH:mm:ss\"">//日期时间型
        <#elseif defDataType == "DATE">
            <#assign expressionCond=expressionCond+",fieldType=\"DATE\",format=\"yyyy-MM-dd\"">//日期型
        <#elseif defDataType == "TIME">
            <#assign expressionCond=expressionCond+",fieldType=\"TIME\",format=\"HH:mm\"">//时间型
        <#elseif defDataType=='PICKUPDATA'&& defStdType=='Timestamp'><#comment>外键值附加数据，数据类型为时间</#comment>
            <#assign expressionCond=expressionCond+",fieldType=\"DATETIME\",format=\"yyyy-MM-dd HH:mm:ss\"">//日期时间型
        </#if>
    <#return expressionCond/>
</#function>